"use client";
import { memo, useEffect, useRef } from "react";
import QRCodeStyling from "qr-code-styling";
import { Button } from "@/components/ui/button";
import { Download } from "lucide-react";

const qrCode = new QRCodeStyling();

const QrCode = memo(function QrCode({ currentDesign }) {
  const ref = useRef(null);

  useEffect(() => {
    if (!ref.current) return null;
    qrCode.append(ref.current);
  }, []);

  useEffect(() => {
    if (!ref.current) return null;
    qrCode.update(currentDesign);
  }, [currentDesign]);

  async function downloadQrCode() {
    await qrCode.download({
      name: "qr-code",
      extension: "png",
    });
  }

  return (
    <div className="grid gap-4 justify-center w-full h-full">
      <div ref={ref} className="*:max-w-80 *:max-h-full *:w-full *:h-full" />
      <Button onClick={downloadQrCode} className="max-w-80">
        <Download className="w-4 h-4" />
        <span>Download</span>
      </Button>
    </div>
  );
});

export default QrCode;
